#version 330

uniform mat4 worldViewProj;
#ifdef _NORMAL
uniform mat4 worldView;
#endif

in vec4 vertex;
#ifdef _NORMAL
in vec3 normal;
#endif
#ifdef _UV
in vec2 uv0;
#endif
#ifdef _VCOLOR
in vec4 colour;
#endif

#ifdef _NORMAL
out vec3 norm;
#endif
#ifdef _UV
out vec2 uv;
#endif
#ifdef _VCOLOR
out vec4 vcolor;
#endif

void main()
{
	gl_Position = worldViewProj*vertex;
#ifdef _NORMAL
	norm = mat3(worldView)*normal;
#endif
#ifdef _UV
    uv = uv0.xy;
#endif
#ifdef _VCOLOR
	vcolor = colour;
#endif
}
